<?php
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");
include ('includes/header.php');

// Configurações
define('BG_UPLOAD_DIR', 'api/bg/');
define('ALLOWED_TYPES', ['image/jpeg', 'image/png', 'image/gif', 'image/webp']);
define('MAX_FILE_SIZE', 5 * 1024 * 1024); // 5MB

// Criar diretório se não existir
if (!file_exists(BG_UPLOAD_DIR)) {
    mkdir(BG_UPLOAD_DIR, 0755, true);
}

// Nome da tabela e variáveis
$table_name = "ads";
$base_file = basename($_SERVER["SCRIPT_NAME"]);

// Criar tabela se não existir
$adb4->exec("CREATE TABLE IF NOT EXISTS {$table_name}(id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, title VARCHAR(100), caminho TEXT)");

// Função para fazer upload de arquivo
function uploadFile($file, $existingFileName = null) {
    if ($file["size"] == 0) {
        return null;
    }
    
    // Verificar tipo e tamanho do arquivo
    if (!in_array($file["type"], ALLOWED_TYPES)) {
        $_SESSION['alert'] = ['type' => 'danger', 'message' => 'Apenas arquivos JPG, JPEG, PNG, GIF e WebP são permitidos.'];
        return null;
    }
    
    if ($file["size"] > MAX_FILE_SIZE) {
        $_SESSION['alert'] = ['type' => 'danger', 'message' => 'O arquivo é muito grande. Tamanho máximo permitido: 5MB.'];
        return null;
    }
    
    $targetDir = BG_UPLOAD_DIR;
    $fileName = $existingFileName ?: 'bg_' . time() . '.' . pathinfo($file["name"], PATHINFO_EXTENSION);
    $targetFile = $targetDir . $fileName;

    if (move_uploaded_file($file["tmp_name"], $targetFile)) {
        return $targetFile;
    } else {
        $_SESSION['alert'] = ['type' => 'danger', 'message' => 'Ocorreu um erro ao fazer o upload do arquivo.'];
        return null;
    }
}

// Função para fazer upload por URL
function uploadFromUrl($url, $existingFileName = null) {
    $imageUrl = filter_var($url, FILTER_VALIDATE_URL);
    
    if (!$imageUrl || !preg_match('/\.(jpg|jpeg|png|gif|webp)$/i', $imageUrl)) {
        $_SESSION['alert'] = ['type' => 'danger', 'message' => 'URL inválida ou não é uma imagem suportada.'];
        return null;
    }
    
    $headers = @get_headers($imageUrl);
    if(!$headers || strpos($headers[0], '200') === false) {
        $_SESSION['alert'] = ['type' => 'danger', 'message' => 'URL inacessível ou inválida.'];
        return null;
    }
    
    $imageData = @file_get_contents($imageUrl);
    if ($imageData === false) {
        $_SESSION['alert'] = ['type' => 'danger', 'message' => 'Falha ao baixar a imagem.'];
        return null;
    }
    
    // Verificar tipo MIME
    $finfo = new finfo(FILEINFO_MIME_TYPE);
    $mime = $finfo->buffer($imageData);
    
    if (!in_array($mime, ALLOWED_TYPES)) {
        $_SESSION['alert'] = ['type' => 'danger', 'message' => 'Tipo de imagem não suportado.'];
        return null;
    }
    
    // Verificar tamanho
    if (strlen($imageData) > MAX_FILE_SIZE) {
        $_SESSION['alert'] = ['type' => 'danger', 'message' => 'A imagem da URL é muito grande. Tamanho máximo permitido: 5MB.'];
        return null;
    }
    
    $fileName = $existingFileName ?: 'bg_' . time() . '.' . pathinfo($imageUrl, PATHINFO_EXTENSION);
    $uploadPath = BG_UPLOAD_DIR . $fileName;
    
    if (!file_put_contents($uploadPath, $imageData)) {
        $_SESSION['alert'] = ['type' => 'danger', 'message' => 'Falha ao salvar a imagem.'];
        return null;
    }
    
    return $uploadPath;
}

// Função para deletar o arquivo de imagem
function deleteFile($filePath) {
    if($filePath && file_exists($filePath)) {
        unlink($filePath);
        return true;
    }
    return false;
}

// Consultas
$res = $adb4->query("SELECT * FROM {$table_name}");
@$resU = $adb4->query("SELECT * FROM {$table_name} WHERE id='{$_GET['update']}'");
@$rowU = $resU->fetchArray();

// Verificar se existem fundos
$countQuery = $adb4->query("SELECT COUNT(*) as total FROM {$table_name}");
$countRow = $countQuery->fetchArray();
$hasFundos = ($countRow['total'] > 0);

// Processar upload via arquivo (apenas para novos registros)
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_FILES["fileToUpload"]) && !isset($_POST['submitU'])) {
    $file_path = uploadFile($_FILES["fileToUpload"]);
    
    if ($file_path !== null) {
        $title = isset($_POST['title']) ? $_POST['title'] : "Fundo Upload";
        $adb4->exec("INSERT INTO {$table_name}(title, caminho) VALUES('{$title}', '{$file_path}')");
        $_SESSION['alert'] = ['type' => 'success', 'message' => 'Fundo enviado com sucesso!'];
        header("Location: bg.php");
        exit;
    }
}

// Processar upload via URL (apenas para novos registros)
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["bg_url"]) && !isset($_POST['submitU'])) {
    $file_path = uploadFromUrl($_POST["bg_url"]);
    
    if ($file_path !== null) {
        $title = isset($_POST['title']) ? $_POST['title'] : "Fundo URL";
        $adb4->exec("INSERT INTO {$table_name}(title, caminho) VALUES('{$title}', '{$file_path}')");
        $_SESSION['alert'] = ['type' => 'success', 'message' => 'Fundo importado com sucesso!'];
        header("Location: bg.php");
        exit;
    }
}

// Processar atualização de registro existente
if (isset($_POST['submitU'])) {
    $id = $_POST['id'];
    $title = $_POST['title'];
    
    // Obter o caminho atual do fundo
    $currentQuery = $adb4->query("SELECT caminho FROM {$table_name} WHERE id={$id}");
    $currentRow = $currentQuery->fetchArray();
    $currentPath = $currentRow['caminho'];
    $existingFileName = $currentPath ? basename($currentPath) : null;
    
    $newPath = $currentPath; // Mantém o caminho atual por padrão
    
    // Verificar se um novo arquivo foi enviado
    if (!empty($_FILES["fileToUpload"]["name"])) {
        $newPath = uploadFile($_FILES["fileToUpload"], $existingFileName);
        
        // Se o novo upload foi bem sucedido e é diferente do atual, remove o antigo
        if ($newPath && $newPath != $currentPath) {
            deleteFile($currentPath);
        } elseif (!$newPath) {
            // Se houve erro no upload, mantém o caminho atual
            $newPath = $currentPath;
        }
    } 
    // Se não enviou arquivo, verifica se enviou URL
    elseif (!empty($_POST["bg_url"])) {
        $urlPath = uploadFromUrl($_POST["bg_url"], $existingFileName);
        
        if ($urlPath) {
            // Remove o arquivo antigo se o novo foi salvo com sucesso e é diferente
            if ($urlPath != $currentPath) {
                deleteFile($currentPath);
            }
            $newPath = $urlPath;
        }
    }
    
    // Atualizar no banco de dados
    $adb4->exec("UPDATE {$table_name} SET title='{$title}', caminho='{$newPath}' WHERE id='{$id}'");
    $_SESSION['alert'] = ['type' => 'success', 'message' => 'Fundo atualizado com sucesso!'];
    header("Location: bg.php?status=1");
    exit;
}

// Processar exclusão
if (isset($_GET['delete'])) {
    $deleteQuery = $adb4->query("SELECT caminho FROM {$table_name} WHERE id={$_GET['delete']}");
    $deleteRow = $deleteQuery->fetchArray();
    $deleteUrl = $deleteRow['caminho'];
    
    deleteFile($deleteUrl);
    
    $adb4->exec("DELETE FROM {$table_name} WHERE id={$_GET['delete']}");
    $_SESSION['alert'] = ['type' => 'success', 'message' => 'Fundo excluído com sucesso!'];
    header("Location: bg.php?status=2");
    exit;
}

// Processar exclusão de todos os registros
if (isset($_GET['deleteall'])) {
    $getAllQuery = $adb4->query("SELECT caminho FROM {$table_name}");
    while ($row = $getAllQuery->fetchArray()) {
        if (!empty($row['caminho']) && file_exists($row['caminho'])) {
            unlink($row['caminho']);
        }
    }
    
    $adb4->exec("DELETE FROM {$table_name}");
    $_SESSION['alert'] = ['type' => 'success', 'message' => 'Todos os fundos foram excluídos com sucesso!'];
    header("Location: bg.php?status=3");
    exit;
}
?>

<style>
/* Main Colors - Dark Blue Theme (inspirado no logo.php) */
:root {
    --primary-blue: #1a237e;
    --dark-blue: #0d1541;
    --accent-blue: #3d5afe;
    --light-blue: #e8eaf6;
    --danger-red: #dc3545;
    --success-green: #28a745;
    --warning-orange: #fd7e14;
    --white: #ffffff;
    --light-gray: #f8f9fa;
    --medium-gray: #e9ecef;
    --dark-gray: #6c757d;
    --black: #212529;
}

/* Card Styles - White with Blue Accents */
.card {
    border: none;
    border-radius: 10px;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
    margin-bottom: 25px;
    background-color: var(--white);
    border: 1px solid var(--light-blue);
}

.card-header {
    border-radius: 10px 10px 0 0 !important;
    padding: 15px 20px;
    font-weight: 600;
    color: var(--white);
    background: linear-gradient(135deg, var(--primary-blue) 0%, var(--dark-blue) 100%) !important;
}

.card-header-smaller h4 {
    font-size: 1.1rem;
    margin-bottom: 0;
}

.card-body {
    padding: 25px;
    background-color: var(--white);
}

/* Form Styles */
.form-control {
    padding: 10px 15px;
    border-radius: 8px;
    border: 1px solid var(--medium-gray);
    transition: all 0.3s;
    background-color: var(--white);
}

.form-control:focus {
    border-color: var(--accent-blue);
    box-shadow: 0 0 0 3px rgba(61, 90, 254, 0.15);
}

.form-label {
    font-weight: 500;
    margin-bottom: 8px;
    color: var(--dark-blue);
    display: block;
}

/* Button Styles */
.btn {
    padding: 8px 16px;
    border-radius: 8px;
    font-weight: 500;
    transition: all 0.3s;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    font-size: 0.85rem;
}

.btn-primary {
    background-color: var(--primary-blue);
    border-color: var(--primary-blue);
    color: var(--white);
}

.btn-primary:hover {
    background-color: var(--dark-blue);
    border-color: var(--dark-blue);
}

.btn-success {
    background-color: var(--success-green);
    border-color: var(--success-green);
    color: var(--white);
}

.btn-success:hover {
    background-color: #218838;
    border-color: #1e7e34;
}

.btn-danger {
    background-color: var(--danger-red);
    border-color: var(--danger-red);
    color: var(--white);
}

.btn-light {
    background-color: var(--light-gray);
    border-color: var(--medium-gray);
}

/* Background Preview */
.bg-preview {
    max-width: 200px;
    max-height: 100px;
    border-radius: 8px;
    border: 1px solid var(--medium-gray);
    margin: 0 auto;
    display: block;
    box-shadow: 0 3px 10px rgba(0,0,0,0.1);
}

.smaller-preview {
    max-width: 150px;
    max-height: 75px;
}

/* Upload Method Selector */
.upload-method {
    display: flex;
    gap: 15px;
    margin-bottom: 20px;
}

.upload-method-btn {
    flex: 1;
    padding: 12px;
    border-radius: 8px;
    background: var(--light-gray);
    border: 1px solid var(--medium-gray);
    cursor: pointer;
    transition: all 0.3s;
    text-align: center;
}

.upload-method-btn.active {
    border-color: var(--accent-blue);
    background-color: rgba(61, 90, 254, 0.1);
}

.upload-method-btn i {
    font-size: 1.3rem;
    margin-bottom: 8px;
    color: var(--accent-blue);
}

/* Table Styles */
.table-responsive {
    overflow-x: auto;
}

.table {
    width: 100%;
    margin-bottom: 1rem;
    color: var(--black);
    background-color: var(--white);
    font-size: 0.9rem;
}

.table th,
.table td {
    padding: 0.75rem;
    vertical-align: middle;
    border-top: 1px solid var(--medium-gray);
}

.table thead th {
    vertical-align: bottom;
    border-bottom: 2px solid var(--medium-gray);
    background-color: var(--light-blue);
    color: var(--dark-blue);
}

.table-striped tbody tr:nth-of-type(odd) {
    background-color: rgba(0, 0, 0, 0.03);
}

.table-hover tbody tr:hover {
    background-color: rgba(0, 0, 0, 0.05);
}

/* Responsive Adjustments */
@media (max-width: 768px) {
    .card-body {
        padding: 20px;
    }
    
    .upload-method {
        flex-direction: column;
    }
    
    .bg-preview {
        max-width: 150px;
        max-height: 75px;
    }
    
    .table-responsive {
        display: block;
        width: 100%;
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
    }
}
</style>

<div class="container-fluid py-4">
    <?php if (isset($_GET['status'])): ?>
        <?php if ($_GET['status'] == 1): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i> Operação realizada com sucesso!
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php elseif ($_GET['status'] == 2): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i> Fundo excluído com sucesso!
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php elseif ($_GET['status'] == 3): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i> Todos os fundos foram excluídos com sucesso!
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php endif; ?>
    <?php endif; ?>

    <?php if (isset($_SESSION['alert'])): ?>
        <div class="alert alert-<?= $_SESSION['alert']['type'] ?> alert-dismissible fade show" role="alert">
            <i class="fas <?= $_SESSION['alert']['type'] === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle' ?> me-2"></i>
            <?= $_SESSION['alert']['message'] ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php unset($_SESSION['alert']); ?>
    <?php endif; ?>

    <?php if (isset($_GET['create'])): ?>
        <!-- Formulário de criação -->
        <div class="row">
            <div class="col-md-8 mx-auto">
                <div class="card shadow-sm">
                    <div class="card-header card-header-smaller">
                        <div class="d-flex justify-content-between align-items-center">
                            <h4 class="mb-0"><i class="fas fa-plus-circle me-2"></i>Novo Fundo</h4>
                            <a href="<?= $base_file ?>" class="btn btn-light btn-smaller">
                                <i class="fas fa-arrow-left me-1"></i> Voltar
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="upload-method">
                            <div class="upload-method-btn active" onclick="showUploadMethod('file')">
                                <i class="fas fa-file-upload"></i>
                                <div>Upload de Arquivo</div>
                            </div>
                            <div class="upload-method-btn" onclick="showUploadMethod('url')">
                                <i class="fas fa-link"></i>
                                <div>Importar por URL</div>
                            </div>
                        </div>
                        
                        <!-- Método: Upload de Arquivo -->
                        <div id="file-upload-method">
                            <form method="post" enctype="multipart/form-data">
                                <div class="mb-3">
                                    <label for="title" class="form-label">Nome do Fundo</label>
                                    <input type="text" class="form-control" id="title" name="title" required>
                                </div>
                                <div class="mb-3">
                                    <label for="fileToUpload" class="form-label">Imagem de Fundo</label>
                                    <input type="file" class="form-control" id="fileToUpload" name="fileToUpload" accept="image/*" required>
                                    <small class="text-muted">Formatos aceitos: JPG, PNG, GIF, WebP (Máx. 5MB)</small>
                                </div>
                                <div class="text-center mt-4">
                                    <button type="submit" class="btn btn-primary px-4 btn-smaller">
                                        <i class="fas fa-save me-2"></i>Salvar
                                    </button>
                                </div>
                            </form>
                        </div>
                        
                        <!-- Método: Importar por URL -->
                        <div id="url-upload-method" style="display: none;">
                            <form method="post">
                                <div class="mb-3">
                                    <label for="title_url" class="form-label">Nome do Fundo</label>
                                    <input type="text" class="form-control" id="title_url" name="title" required>
                                </div>
                                <div class="mb-3">
                                    <label for="bg_url" class="form-label">URL da Imagem</label>
                                    <input type="url" class="form-control" id="bg_url" name="bg_url" 
                                           placeholder="https://exemplo.com/fundo.jpg" required>
                                    <small class="text-muted">Informe uma URL direta para uma imagem</small>
                                </div>
                                <div class="text-center mt-4">
                                    <button type="submit" class="btn btn-success px-4 btn-smaller">
                                        <i class="fas fa-download me-2"></i>Importar
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    
    <?php elseif (isset($_GET['update'])): ?>
        <!-- Formulário de edição -->
        <div class="row">
            <div class="col-md-8 mx-auto">
                <div class="card shadow-sm">
                    <div class="card-header card-header-smaller">
                        <div class="d-flex justify-content-between align-items-center">
                            <h4 class="mb-0"><i class="fas fa-edit me-2"></i>Editar Fundo</h4>
                            <a href="<?= $base_file ?>" class="btn btn-light btn-smaller">
                                <i class="fas fa-arrow-left me-1"></i> Voltar
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <form method="post" enctype="multipart/form-data">
                            <input type="hidden" name="id" value="<?= $_GET['update'] ?>">
                            <div class="mb-3">
                                <label for="title" class="form-label">Nome do Fundo</label>
                                <input type="text" class="form-control" id="title" name="title" value="<?= htmlspecialchars($rowU['title']) ?>" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Imagem Atual</label>
                                <?php if (!empty($rowU['caminho']) && file_exists($rowU['caminho'])): ?>
                                    <img src="<?= $rowU['caminho'] ?>" class="bg-preview d-block mb-2">
                                    <small class="text-muted"><?= basename($rowU['caminho']) ?></small>
                                <?php else: ?>
                                    <p class="text-muted">Nenhuma imagem carregada</p>
                                <?php endif; ?>
                            </div>
                            <div class="mb-3">
                                <label for="fileToUpload" class="form-label">Substituir por novo arquivo</label>
                                <input type="file" class="form-control" id="fileToUpload" name="fileToUpload" accept="image/*">
                                <small class="text-muted">Deixe em branco para manter a imagem atual</small>
                            </div>
                            <div class="mb-3">
                                <label for="bg_url" class="form-label">Ou substituir por URL</label>
                                <input type="url" class="form-control" id="bg_url" name="bg_url" 
                                       placeholder="https://exemplo.com/fundo.jpg">
                                <small class="text-muted">Informe uma URL para substituir a imagem atual</small>
                            </div>
                            <div class="text-center mt-4">
                                <button type="submit" name="submitU" class="btn btn-primary px-4 btn-smaller">
                                    <i class="fas fa-save me-2"></i>Atualizar
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    
    <?php else: ?>
        <!-- Lista de fundos -->
        <div class="row">
            <div class="col-12">
                <div class="card shadow-sm">
                    <div class="card-header card-header-smaller">
                        <div class="d-flex justify-content-between align-items-center">
                            <h4 class="mb-0"><i class="fas fa-image me-2"></i>Gerenciamento de Fundos</h4>
                            <div>
                                <?php if ($hasFundos): ?>
                                <a href="<?= $base_file ?>?deleteall" class="btn btn-danger btn-smaller me-2" onclick="return confirm('Tem certeza que deseja excluir TODOS os fundos? Esta ação não pode ser desfeita e todos os arquivos serão removidos.');">
                                    <i class="fas fa-trash-alt me-1"></i> Remover Todos
                                </a>
                                <?php endif; ?>
                                <a href="rename.php" class="btn btn-outline-success btn-smaller me-2">
                                    <i class="fas fa-sync-alt me-1"></i> Automático
                                </a>
                                <a href="<?= $base_file ?>?create" class="btn btn-light btn-smaller">
                                    <i class="fas fa-plus me-1"></i> Novo Fundo
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php if ($hasFundos): ?>
                        <div class="table-responsive">
                            <table class="table table-hover table-striped">
                                <thead>
                                    <tr>
                                        <th width="5%">ID</th>
                                        <th width="25%">Nome</th>
                                        <th width="50%">Prévia</th>
                                        <th width="20%" class="text-center">Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                    $listRes = $adb4->query("SELECT * FROM {$table_name}");
                                    while ($row = $listRes->fetchArray()): 
                                    ?>
                                    <tr>
                                        <td><?= $row['id'] ?></td>
                                        <td><?= htmlspecialchars($row['title']) ?></td>
                                        <td>
                                            <?php if (!empty($row['caminho']) && file_exists($row['caminho'])): ?>
                                                <img src="<?= $row['caminho'] ?>" class="bg-preview smaller-preview">
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-center">
                                            <a href="<?= $base_file ?>?update=<?= $row['id'] ?>" class="btn btn-outline-primary btn-sm me-1">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <a href="<?= $base_file ?>?delete=<?= $row['id'] ?>" class="btn btn-outline-danger btn-sm" onclick="return confirm('Tem certeza que deseja excluir este fundo? Esta ação não pode ser desfeita.');">
                                                <i class="fas fa-trash-alt"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                        <?php else: ?>
                        <div class="text-center py-4">
                            <i class="fas fa-image fa-3x text-muted mb-3"></i>
                            <p class="text-muted">Nenhum fundo encontrado. Clique em "Novo Fundo" para adicionar.</p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<script>
// Mostrar método de upload selecionado
function showUploadMethod(method) {
    document.querySelectorAll('.upload-method-btn').forEach(btn => {
        btn.classList.remove('active');
    });
    
    if (method === 'file') {
        document.getElementById('file-upload-method').style.display = 'block';
        document.getElementById('url-upload-method').style.display = 'none';
        document.querySelector('.upload-method-btn:nth-child(1)').classList.add('active');
    } else {
        document.getElementById('file-upload-method').style.display = 'none';
        document.getElementById('url-upload-method').style.display = 'block';
        document.querySelector('.upload-method-btn:nth-child(2)').classList.add('active');
    }
}

// Fechar alertas automaticamente
setTimeout(function() {
    document.querySelectorAll('.alert').forEach(function(alert) {
        var closeButton = alert.querySelector('.btn-close');
        if (closeButton) {
            closeButton.click();
        }
    });
}, 5000);
</script>

<?php 
include ('includes/footer.php');
?>