<?php
ini_set("display_errors", 1);
error_reporting(32767);
include "includes/header.php";
$dbPath = "./api/.db.db";
$db = new SQLiteWrapper($dbPath);

if (isset($_POST["theme_id"])) {
    $themeData = ["theme_id" => $_POST["theme_id"]];
    $db->update("themes", $themeData, "id = :id", [":id" => 1]);
    echo "<script>window.location.href='" . basename($_SERVER["SCRIPT_NAME"]) . "?status=1'</script>";
}

$currentThemeId = $db->select("themes", "theme_id", "id = 1", "")[0]["theme_id"];
?>

<div class="container-fluid py-4">
    <div class="row">
        <div class="col-md-8 mx-auto">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="mb-0"><i class="fas fa-palette me-2"></i>Theme settings</h4>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Theme Thumbnails -->
                    <div class="theme-thumbnails">
                        <?php 
                        $themeNumbers = [1, 4, 2, 5]; // Excluindo temas 3 e 6
                        foreach ($themeNumbers as $num): ?>
                            <div class="theme-preview <?= $currentThemeId == $num ? 'selected-theme animate-theme' : '' ?>">
                                <div class="theme-image-container">
                                    <img src="img/theme_<?= $num ?>.png?v=<?= time() ?>" alt="Theme <?= $num ?>" class="img-fluid">
                                    <?php if ($currentThemeId == $num): ?>
                                        <div class="selected-badge">
                                            <i class="fas fa-check-circle"></i>Active
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <form method="post" class="mt-3 text-center">
                                    <input type="hidden" name="theme_id" value="<?= $num ?>">
                                    <button type="submit" class="btn <?= $currentThemeId == $num ? 'btn-success' : 'btn-danger' ?> w-100">
                                        <?= $currentThemeId == $num ? 'Ativado' : 'Ativar Tema' ?>
                                    </button>
                                </form>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.card {
    border: none;
    border-radius: 8px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
}

.card-header {
    border-radius: 8px 8px 0 0 !important;
    background: linear-gradient(135deg, var(--primary-blue) 0%, var(--dark-blue) 100%) !important;
}

.theme-thumbnails {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 20px;
    margin-top: 30px;
}

.theme-preview {
    background: var(--white);
    border-radius: 8px;
    padding: 15px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    transition: all 0.3s ease;
    border: 2px solid transparent;
    position: relative;
}

.theme-preview:hover {
    transform: translateY(-5px);
    box-shadow: 0 6px 15px rgba(0, 0, 0, 0.1);
}

.selected-theme {
    border-color: var(--primary-blue);
    background-color: rgba(67, 97, 238, 0.05);
}

/* ANIMAÇÃO */
.animate-theme {
    animation: pulse 1.5s infinite;
}

@keyframes pulse {
    0% { box-shadow: 0 0 0 0 rgba(0, 123, 255, 0.4); }
    70% { box-shadow: 0 0 0 10px rgba(0, 123, 255, 0); }
    100% { box-shadow: 0 0 0 0 rgba(0, 123, 255, 0); }
}

.theme-image-container {
    position: relative;
    overflow: hidden;
    border-radius: 6px;
    text-align: center;
}

.theme-image-container img {
    width: 95%;
    max-width: 350px;
    height: auto;
    display: inline-block;
    border-radius: 6px;
}

.selected-badge {
    position: absolute;
    bottom: 10px;
    right: 10px;
    background: var(--primary-blue);
    color: white;
    padding: 5px 10px;
    border-radius: 20px;
    font-size: 0.8rem;
    display: flex;
    align-items: center;
    gap: 5px;
}

.selected-badge i {
    font-size: 1rem;
}

.btn-success {
    background-color: #28a745;
    border-color: #28a745;
}

.btn-success:hover {
    background-color: #218838;
    border-color: #1e7e34;
}

.btn-danger {
    background-color: #dc3545;
    border-color: #dc3545;
}

.btn-danger:hover {
    background-color: #c82333;
    border-color: #bd2130;
}

@media (max-width: 768px) {
    .theme-thumbnails {
        grid-template-columns: 1fr;
    }
}
</style>

<?php 
include "includes/footer.php";
?>
