<?php

header("Cache-Control: no-cache, no-store, must-revalidate"); // HTTP 1.1.
header("Pragma: no-cache"); // HTTP 1.0.
header("Expires: 0"); // Proxies.
include ('includes/header.php'); // Certifique-se de que este arquivo existe e configura $adb4 (conexão com o banco de dados)

// Função para fazer o upload do arquivo
function uploadFile($file, $existingFileName = null) {
    // Verifica se houve algum erro no upload
    if ($file["error"] !== UPLOAD_ERR_OK) {
        switch ($file["error"]) {
            case UPLOAD_ERR_INI_SIZE:
            case UPLOAD_ERR_FORM_SIZE:
                echo "Erro: O arquivo excede o tamanho máximo permitido.";
                break;
            case UPLOAD_ERR_PARTIAL:
                echo "Erro: O upload do arquivo foi feito apenas parcialmente.";
                break;
            case UPLOAD_ERR_NO_FILE:
                // Se nenhum arquivo foi selecionado, retorna null e não exibe erro.
                // Isso permite o cenário onde o usuário não quer mudar a imagem.
                return null;
            case UPLOAD_ERR_NO_TMP_DIR:
                echo "Erro: Faltando uma pasta temporária no servidor.";
                break;
            case UPLOAD_ERR_CANT_WRITE:
                echo "Erro: Falha ao escrever o arquivo no disco.";
                break;
            case UPLOAD_ERR_EXTENSION:
                echo "Erro: Uma extensão PHP impediu o upload do arquivo.";
                break;
            default:
                echo "Erro: Ocorreu um erro desconhecido no upload.";
                break;
        }
        return null; // Retorna null em caso de erro no upload
    }

    // Se nenhum arquivo foi selecionado (tamanho 0 após passar pela verificação de erro)
    if ($file["size"] == 0) {
        return null;
    }

    $targetDir = "api/uploads/";

    // Cria o diretório de uploads se ele não existir
    if (!file_exists($targetDir)) {
        if (!mkdir($targetDir, 0755, true)) { // Tenta criar o diretório com permissões 0755 e recursivamente
            echo "Erro: Não foi possível criar o diretório de uploads: $targetDir. Verifique as permissões.";
            return null;
        }
    }
    
    // Obter a extensão do arquivo
    $fileExtension = strtolower(pathinfo($file["name"], PATHINFO_EXTENSION));
    
    // Usar o nome de arquivo existente se fornecido, senão gerar um nome único
    if ($existingFileName) {
        $uniqueFileName = $existingFileName;
    } else {
        $currentDateTime = date('YmdHis');
        $uniqueFileName = $currentDateTime . '_' . uniqid() . '.' . $fileExtension; // Adiciona uniqid para maior exclusividade
    }
    
    // Caminho completo para o arquivo de destino
    $targetFile = $targetDir . $uniqueFileName;
    
    $uploadOk = 1;

    // Permitir apenas alguns formatos de arquivo
    if($fileExtension != "jpg" && $fileExtension != "png" && $fileExtension != "jpeg" && $fileExtension != "gif") {
        echo "Desculpe, apenas arquivos JPG, JPEG, PNG e GIF são permitidos.";
        $uploadOk = 0;
    }

    // Verifica se $uploadOk ainda é 1 antes de tentar mover o arquivo
    if ($uploadOk == 0) {
        echo "Desculpe, seu arquivo não foi enviado devido a restrições de tipo.";
        return null;
    } else {
        // CORREÇÃO: Usar is_uploaded_file() para segurança antes de move_uploaded_file()
        if (is_uploaded_file($file["tmp_name"])) {
            if (move_uploaded_file($file["tmp_name"], $targetFile)) {
                return $targetFile; // Retorna o caminho do arquivo salvo
            } else {
                echo "Desculpe, ocorreu um erro ao fazer o upload do arquivo. Verifique as permissões da pasta '$targetDir'.";
                return null;
            }
        } else {
            echo "Erro de segurança: O arquivo não é um upload válido.";
            return null;
        }
    }
}

// Função para deletar o arquivo de imagem
function deleteFile($url) {
    // Certifique-se de que o caminho é local e não um URL externo, para evitar deletar arquivos de outros servidores.
    // Pode ser necessário ajustar o caminho para ser relativo ao diretório raiz do script.
    $localPath = str_replace(basename($_SERVER["SCRIPT_NAME"]), '', $_SERVER["SCRIPT_FILENAME"]) . $url; // Exemplo de como construir um caminho absoluto
    
    if(file_exists($url) && is_file($url)) { // Verifica se existe e é um arquivo
        if (unlink($url)) {
            // echo "Arquivo deletado com sucesso: " . $url;
        } else {
            // echo "Erro ao deletar o arquivo: " . $url . ". Verifique as permissões.";
        }
    }
}

// Nome da tabela
$table_name = "ads";

// Variável do arquivo atual
$base_file = basename($_SERVER["SCRIPT_NAME"]);

// Criar tabela se não existir
// IMPORTANTE: Para SQLite (assumindo $adb4 é uma instância de SQLite3), certifique-se que o banco de dados tem permissões de escrita.
$adb4->exec("CREATE TABLE IF NOT EXISTS {$table_name}(id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, title VARCHAR(100), caminho TEXT)");

// Consulta à tabela
$res = $adb4->query("SELECT * FROM {$table_name}");

// Consulta de atualização
@$resU = $adb4->query("SELECT * FROM {$table_name} WHERE id='{$_GET['update']}'");
@$rowU = $resU->fetchArray();

// --- Processamento de Atualização (UPDATE) ---
if (isset($_POST['submitU'])) {
    $file_path = null;
    $newFileUploaded = !empty($_FILES["fileToUpload"]["name"]);
    
    $updateId = isset($_POST['id']) ? $_POST['id'] : null;

    if ($updateId) {
        // Obter o URL do arquivo atual apenas se um novo arquivo não foi enviado ou se for para manter o existente
        $updateQuery = $adb4->query("SELECT caminho, title FROM {$table_name} WHERE id=" . (int)$updateId);
        $updateRow = $updateQuery->fetchArray(SQLITE3_ASSOC); // Usar SQLITE3_ASSOC para chaves associativas

        $currentFileUrl = $updateRow['caminho'];
        $existingTitle = $updateRow['title'];

        if ($newFileUploaded) {
            $existingFileName = basename($currentFileUrl);
            // Fazer o upload do novo arquivo com o nome do arquivo existente (se desejar manter o nome)
            // Ou gerar um novo nome único se existingFileName for null na função uploadFile
            $file_path = uploadFile($_FILES["fileToUpload"], $existingFileName);

            // Se um novo arquivo foi enviado com sucesso, excluir o arquivo antigo
            if ($file_path !== null && $file_path != $currentFileUrl) {
                deleteFile($currentFileUrl);
            }
        } else {
            // Se nenhum novo arquivo foi enviado, manter o caminho existente
            $file_path = $currentFileUrl;
        }

        $title = isset($_POST['title']) ? $_POST['title'] : $existingTitle;
        $caminho = $file_path; // $file_path já conterá o novo ou o antigo caminho

        // IMPORTANTE: Usar Prepared Statements para segurança contra Injeção de SQL
        // Exemplo para SQLite3:
        $stmt = $adb4->prepare("UPDATE {$table_name} SET title=:title, caminho=:caminho WHERE id=:id");
        $stmt->bindValue(':title', $title, SQLITE3_TEXT);
        $stmt->bindValue(':caminho', $caminho, SQLITE3_TEXT);
        $stmt->bindValue(':id', (int)$updateId, SQLITE3_INTEGER);

        if ($stmt->execute()) {
            // Sucesso na atualização
        } else {
            echo "Erro ao atualizar o registro: " . $adb4->lastErrorMsg();
        }
        $adb4->close();
        echo "<script>window.location.href='bg.php';</script>";
        exit;
    } else {
        echo "ID para atualização não fornecido.";
    }
}

// --- Processamento de Adição (CREATE) ---
if (isset($_POST['submit'])) {
    $file_path = null;
    if (!empty($_FILES["fileToUpload"]["name"])) {
        $file_path = uploadFile($_FILES["fileToUpload"]);
    }
    
    // Pelo menos um título ou um arquivo deve ser enviado
    if ($file_path !== null || !empty($_POST['title'])) {
        $title = isset($_POST['title']) ? $_POST['title'] : "";
        $caminho = $file_path !== null ? $file_path : ""; // Caminho pode ser vazio se nenhum arquivo foi upado

        // IMPORTANTE: Usar Prepared Statements para segurança contra Injeção de SQL
        // Exemplo para SQLite3:
        $stmt = $adb4->prepare("INSERT INTO {$table_name}(title, caminho) VALUES(:title, :caminho)");
        $stmt->bindValue(':title', $title, SQLITE3_TEXT);
        $stmt->bindValue(':caminho', $caminho, SQLITE3_TEXT);

        if ($stmt->execute()) {
            // Sucesso na inserção
        } else {
            echo "Erro ao inserir o registro: " . $adb4->lastErrorMsg();
        }
        $adb4->close();
        echo "<script>window.location.href='bg.php';</script>";
        exit;
    } else {
        echo "Nenhum dado (título ou arquivo) enviado para adicionar.";
    }
}

// --- Processamento de Exclusão (DELETE) ---
if (isset($_GET['delete'])) {
    $deleteId = (int)$_GET['delete']; // Garante que é um inteiro

    // Busca o URL do arquivo a ser deletado
    $deleteQuery = $adb4->query("SELECT caminho FROM {$table_name} WHERE id=" . $deleteId);
    $deleteRow = $deleteQuery->fetchArray(SQLITE3_ASSOC);
    $deleteUrl = $deleteRow['caminho'];
    
    // Deleta o arquivo de imagem correspondente
    deleteFile($deleteUrl);
    
    // Deleta o registro do banco de dados
    // IMPORTANTE: Usar Prepared Statements para segurança contra Injeção de SQL
    $stmt = $adb4->prepare("DELETE FROM {$table_name} WHERE id=:id");
    $stmt->bindValue(':id', $deleteId, SQLITE3_INTEGER);

    if ($stmt->execute()) {
        // Sucesso na exclusão
    } else {
        echo "Erro ao deletar o registro: " . $adb4->lastErrorMsg();
    }
    
    // Redireciona para a página principal
    echo "<script>window.location.href='bg.php';</script>";
    exit;
}

?>

<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content" style="background-color: black;">
            <div class="modal-header">
                <h2 style="color: white;">CONFIRMAR</h2>
            </div>
            <div class="modal-body" style="color: white;">
                QUER MESMO DELETAR?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">CANCELAR</button>
                <a style="color: white;" class="btn btn-danger btn-ok">DELETAR</a>
            </div>
        </div>
    </div>
</div>

<?php
if (isset($_GET['create'])) {
?>
<div class="card radius-10">
    <center>
        <h2 class="colorboard"></i>NOVO FUNDO</h2>
    </center>
    <div class="card radius-10">
        <div class="card-header">
            </center>
        </div>
        <div class="card-body">
            <form method="post" enctype="multipart/form-data">
                <div class="form-group">
                    <input class="form-control" type="text" name="title" placeholder="Digite o nome do fundo">
                    <label>NOME DO FUNDO</label>
                </div>
                <div class="form-group">
                    <label for="fileToUpload">Selecione o arquivo:</label>
                    <input type="file" name="fileToUpload" id="fileToUpload">
                </div>
                <div class="col-12">
                    <button type="submit" name="submit" class="btn btn-info">SALVAR</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php
} else if (isset($_GET['update'])) {
?>
<div class="card radius-10">
    <center>
        <h2 class="colorboard"></i>EDITAR FUNDO</h2>
    </center>
    <div class="card radius-10">
        <div class="card-header">
            </center>
        </div>
        <div class="card-body">
            <form method="post" enctype="multipart/form-data">
                <input type="hidden" class="form-control" name="id" value="<?=htmlspecialchars($_GET['update']) ?>">
                <div class="user-box">
                    <input type="text" name="title" class="form-control" value="<?=htmlspecialchars($rowU['title']) ?>">
                    <label>NOME DO FUNDO</label>
                </div>
                <div class="user-box">
                    <label for="fileToUpload">Alterar arquivo (opcional):</label>
                    <input type="file" name="fileToUpload" id="fileToUpload">
                    <?php if (!empty($rowU['caminho'])) { ?>
                        <br><br>
                        <p>Arquivo atual:</p>
                        <?php if (strpos($rowU['caminho'], '.jpg') !== false || strpos($rowU['caminho'], '.jpeg') !== false || strpos($rowU['caminho'], '.png') !== false || strpos($rowU['caminho'], '.gif') !== false) { ?>
                            <img src="<?=htmlspecialchars($rowU['caminho'])?>" width="100px" />
                        <?php } else { ?>
                            <p><?=htmlspecialchars($rowU['caminho'])?></p>
                        <?php } ?>
                    <?php } ?>
                    <br><br>
                </div>
                <div class="col-12">
                    <button type="submit" name="submitU" class="btn btn-info">SALVAR</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php
} else {
?>
<div class="card radius-10">
    <center>
        <h1 class="colorboard"></i> IMAGEM APP</h1>
        <br>
        <br>
        <a id="button" href="./<?php echo htmlspecialchars($base_file) ?>?create" class="btn btn-primary">NOVO</a>
    </center>
    <br>
    <div class="table-responsive">
        <table class="table table-striped table-sm">
            <thead style="color:grey!important">
                <tr>
                    <th>ID</th>
                    <th>NOME</th>
                    <th>PRÉVIA</th>
                    <th>AÇÕES</th>
                </tr>
            </thead>
            <tbody>
            <?php while ($row = $res->fetchArray(SQLITE3_ASSOC)) { // Usar SQLITE3_ASSOC para chaves associativas ?>
                <tr>
                    <td><?=htmlspecialchars($row['id']) ?></td>
                    <td><?=htmlspecialchars($row['title']) ?></td>
                    <td>
                        <?php 
                        $caminho = htmlspecialchars($row['caminho']);
                        if (!empty($caminho) && (strpos($caminho, '.jpg') !== false || strpos($caminho, '.jpeg') !== false || strpos($caminho, '.png') !== false || strpos($caminho, '.gif') !== false)) { 
                        ?>
                            <img src="<?=$caminho?>" width="100px"/>
                        <?php } else { ?>
                            N/A
                        <?php } ?>
                    </td>
                    <td>
                        <a href="./<?php echo htmlspecialchars($base_file) ?>?update=<?= htmlspecialchars($row['id']) ?>" class="btn btn-warning">EDITAR</a>
                        <a href="#" class="btn btn-danger" data-toggle="modal" data-target="#confirm-delete" data-href="./<?php echo htmlspecialchars($base_file) ?>?delete=<?= htmlspecialchars($row['id']) ?>">DELETAR</a>
                    </td>
                </tr>
            <?php } ?>
            </tbody>
        </table>
    </div>
</div>

<?php } ?>

<?php include ('includes/footer.php'); ?>
<script type="text/javascript">
// Alerta de sucesso (se você tiver um elemento com id "success-alert" em seu header.php/footer.php)
// $("#success-alert").fadeTo(2000, 500).slideUp(500, function(){
//     $("#success-alert").alert('close');
// });

// Modal de confirmação de deleção
$('#confirm-delete').on('show.bs.modal', function(e) {
    $(this).find('.btn-ok').attr('href', $(e.relatedTarget).data('href'));
});
</script>
</body>
</html>