<?php

ini_set("display_errors", 0); // Desabilita a exibição de erros em ambiente de produção
include "includes/header.php"; // Inclui o cabeçalho (pode conter HTML, CSS, início da sessão, etc.)

// --- Configurações CSS Embutidas (Idealmente, mover para um arquivo .css) ---
echo <<<CSS
<style>
    .custom-button {
        padding: 10px 20px;
    }

    #url-form {
        display: none; /* Mantido conforme o original, assumindo que é controlado por JS */
    }

    .custom-input {
        color: blue;
    }
</style>
CSS;

// --- Bloco PHP Principal: Lógica do Banco de Dados e Processamento POST ---

// Conexão com o banco de dados SQLite
$db_path = "./api/.db_ads.db";
$db = new SQLite3($db_path);

if (!$db) {
    exit("Erro de conexão com o banco de dados: " . $db->lastErrorMsg());
}

// Cria a tabela 'adsstatus' se ela não existir
$query_create_table = "CREATE TABLE IF NOT EXISTS adsstatus (id INTEGER PRIMARY KEY, adstype TEXT)";
if (!$db->exec($query_create_table)) {
    echo "Erro ao criar tabela: " . $db->lastErrorMsg() . "<br>";
}

// Verifica se já existe um registro na tabela
$query_count_records = "SELECT COUNT(*) FROM adsstatus";
$record_count = $db->querySingle($query_count_records);

// Processa o formulário quando enviado via POST
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $ad_item = isset($_POST["ad_item"]) ? $_POST["ad_item"] : '';

    if (empty($ad_item)) {
        echo "<div class='alert alert-danger'>Por favor, selecione um tipo de anúncio.</div>";
    } else {
        // Decide se insere ou atualiza o registro
        if ($record_count === 0) {
            $sql_query = "INSERT INTO adsstatus (adstype) VALUES (:ad_item)";
        } else {
            $sql_query = "UPDATE adsstatus SET adstype = :ad_item WHERE id = 1";
        }

        // Prepara e executa a query usando prepared statements
        $stmt = $db->prepare($sql_query);
        $stmt->bindValue(":ad_item", $ad_item, SQLITE3_TEXT);

        if ($stmt->execute()) {
            echo "<div class='alert alert-success'>Tipo de anúncio '<strong>" . htmlspecialchars($ad_item) . "</strong>' atualizado com sucesso.</div>";

            // Lógica para copiar o arquivo allads.php com base na seleção
            $source_base_dir = "./";
            $destination_file = "./api/allads.php";

            // Apenas para Autoads, já que Manualads foi removido
            if ($ad_item === "Autoads") {
                $source_file = $source_base_dir . "Autoads/allads.php";
                if (file_exists($source_file)) {
                    if (copy($source_file, $destination_file)) {
                        // Opcional: Mensagem de sucesso para a cópia do arquivo
                    } else {
                        echo "<div class='alert alert-danger'>Erro ao copiar o arquivo 'allads.php'. Verifique as permissões da pasta 'api/'.</div>";
                    }
                } else {
                    echo "<div class='alert alert-danger'>Erro: Arquivo 'allads.php' não encontrado na pasta 'Autoads'.</div>";
                }
            } else {
                echo "<div class='alert alert-warning'>Nenhuma ação de cópia de arquivo para o tipo de anúncio selecionado.</div>";
            }
        } else {
            echo "<div class='alert alert-danger'>Erro ao atualizar o registro: " . $db->lastErrorMsg() . "</div>";
        }
    }
}

// Recupera o tipo de anúncio atualmente selecionado para pré-selecionar no dropdown
$current_ad_type = '';
$result_current = $db->querySingle("SELECT adstype FROM adsstatus WHERE id = 1", true);
if ($result_current && isset($result_current['adstype'])) {
    $current_ad_type = $result_current['adstype'];
}

// --- Fim do Bloco PHP Principal ---
?>

<div class="col-md-6 mx-auto">
    <div class="modal fade" id="how2" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Como Usar?</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Aqui você pode gerenciar as configurações dos anúncios do seu aplicativo.</p>
                    <p>Atualmente, apenas a opção "Anúncios Automáticos" está disponível.</p>
                    <p>Ao selecionar a opção, o arquivo 'allads.php' correspondente será copiado para a pasta 'api/'.</p>
                    <p>Para mais informações sobre o widget, visite:</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <a href="https://www.tvsportguide.com/page/widget/" target="_blank" rel="noopener noreferrer">
                        <button type="button" class="btn btn-primary">Ir para a Página</button>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="card-body">
        <div class="card ctcard">
            <div class="card-header">
                <center>
                    <h2><i class="fa fa-file-image-o"></i> Advert's Settings</h2>
                </center>
            </div>
            <div class="card-body">
                <form method="POST" action="">
                    <div class="form-group ctinput">
                        <label for="ad_item">Selecione um Tipo de Anúncio:</label>
                        <select name="ad_item" id="ad_item" class="form-control">
                            <option value="Autoads" <?= ($current_ad_type === 'Autoads' ? 'selected' : '') ?>>Anúncios Automáticos</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <input type="submit" name="submit" value="Atualizar" class="ctbtn ctuserbtn btn btn-primary">
                    </div>

                    <button type="button" class="btn btn-info custom-button" data-toggle="modal" data-target="#how2">
                        Como usar?
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php
include "includes/footer.php"; // Inclui o rodapé
if ($db) {
    $db->close(); // Fecha a conexão com o banco de dados
}
?>