<?php
/*
 * @ https://hospedagem.matrixch.store 
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 17/06/2024
*/

ini_set("display_errors", 0);
include "includes/header.php";

$db = new SQLite3("./api/.db_ads.db");
if (!$db) {
    exit("Erro na conexão com o banco de dados.");
}

// Criar tabela se não existir
$query = "CREATE TABLE IF NOT EXISTS adsstatus (id INTEGER PRIMARY KEY, adstype TEXT)";
if (!$db->exec($query)) {
    echo "<div class='alert alert-danger'>Erro ao criar tabela: " . $db->lastErrorMsg() . "</div>";
}

// Verificar se há registros
$query = "SELECT COUNT(*) FROM adsstatus";
$result = $db->querySingle($query);

// Processar formulário
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $ad_item = $_POST["ad_item"] ?? '';
    
    if (empty($ad_item)) {
        echo "<div class='alert alert-danger'>Por favor, selecione um tipo de anúncio.</div>";
    } else {
        if ($result === 0) {
            $updateQuery = "INSERT INTO adsstatus (adstype) VALUES (:ad_item)";
        } else {
            $updateQuery = "UPDATE adsstatus SET adstype = :ad_item WHERE id = 1";
        }
        
        $stmt = $db->prepare($updateQuery);
        $stmt->bindValue(":ad_item", $ad_item, SQLITE3_TEXT);
        
        if ($stmt->execute()) {
            // Copiar arquivos conforme seleção
            if ($ad_item === "Manualads") {
                $source = "./Manualads/allads.php";
                $destination = "./api/allads.php";
                if (file_exists($source)) {
                    if (copy($source, $destination)) {
                        echo "<div class='alert alert-success'>Configuração 'Anúncios manuais' atualizada com sucesso e arquivos copiados.</div>";
                    } else {
                        echo "<div class='alert alert-warning'>Configurações atualizadas mas falha ao copiar arquivos.</div>";
                    }
                } else {
                    echo "<div class='alert alert-warning'>Configurações atualizadas mas arquivo de origem não encontrado.</div>";
                }
            } elseif ($ad_item === "Autoads") {
                $source = "./Autoads/allads.php";
                $destination = "./api/allads.php";
                if (file_exists($source)) {
                    if (copy($source, $destination)) {
                        echo "<div class='alert alert-success'>Configuração 'Anúncios automáticos' atualizada com sucesso e arquivos copiados.</div>";
                    } else {
                        echo "<div class='alert alert-warning'>Configurações atualizadas mas falha ao copiar arquivos.</div>";
                    }
                } else {
                    echo "<div class='alert alert-warning'>Configurações atualizadas mas arquivo de origem não encontrado.</div>";
                }
            }
        } else {
            echo "<div class='alert alert-danger'>Erro ao atualizar registro: " . $db->lastErrorMsg() . "</div>";
        }
    }
}

// Obter o valor atual
$current_ad_type = "Autoads"; // valor padrão
$query = "SELECT adstype FROM adsstatus WHERE id = 1";
$current = $db->querySingle($query);
if ($current) {
    $current_ad_type = $current;
}
?>

<style>
/* Cores Principais - Tema Azul Escuro */
:root {
    --primary-blue: #1a237e;
    --dark-blue: #0d1541;
    --accent-blue: #3d5afe;
    --light-blue: #e8eaf6;
    --danger-red: #dc3545;
    --success-green: #28a745;
    --warning-orange: #fd7e14;
    --white: #ffffff;
    --light-gray: #f8f9fa;
    --medium-gray: #e9ecef;
    --dark-gray: #6c757d;
    --black: #212529;
}

/* Estilos de Card */
.card {
    border: none;
    border-radius: 8px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
    margin-bottom: 20px;
    background-color: var(--white);
    border: 1px solid var(--light-blue);
}

.card-header {
    border-radius: 8px 8px 0 0 !important;
    padding: 15px 20px;
    font-weight: 600;
    color: var(--white);
    background: linear-gradient(135deg, var(--primary-blue) 0%, var(--dark-blue) 100%) !important;
}

.card-body {
    padding: 25px;
    background-color: var(--white);
}

/* Estilos de Formulário */
.form-control, .form-select {
    padding: 10px 15px;
    border-radius: 6px;
    border: 1px solid var(--medium-gray);
    transition: all 0.3s;
    background-color: var(--white);
}

.form-control:focus, .form-select:focus {
    border-color: var(--accent-blue);
    box-shadow: 0 0 0 0.25rem rgba(61, 90, 254, 0.15);
}

.form-label {
    font-weight: 500;
    margin-bottom: 8px;
    color: var(--dark-blue);
}

/* Estilos de Botão */
.btn {
    padding: 10px 20px;
    border-radius: 6px;
    font-weight: 500;
    transition: all 0.3s;
    display: inline-flex;
    align-items: center;
    justify-content: center;
}

.btn-primary {
    background-color: var(--primary-blue);
    border-color: var(--primary-blue);
    color: var(--white);
}

.btn-primary:hover {
    background-color: var(--dark-blue);
    border-color: var(--dark-blue);
}

/* Ajustes Responsivos */
@media (max-width: 768px) {
    .card-body {
        padding: 15px;
    }
}

/* Estilos personalizados para esta página */
.ads-option {
    padding: 15px;
    margin-bottom: 15px;
    border-radius: 6px;
    background-color: var(--light-gray);
    border-left: 4px solid var(--accent-blue);
}

.ads-option h5 {
    color: var(--primary-blue);
}

.ads-description {
    color: var(--dark-gray);
    font-size: 0.9rem;
}
</style>

<div class="container-fluid py-4">
    <div class="row">
        <div class="col-md-8 mx-auto">
            <div class="card shadow-sm">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="mb-0"><i class="fas fa-ad me-2"></i>Configurações de Anúncios</h4>
                    </div>
                </div>
                <div class="card-body">
                    <form method="POST">
                        <div class="mb-4">
                            <label for="ad_item" class="form-label">Selecione o Tipo de Anúncio:</label>
                            <select class="form-select" name="ad_item" id="ad_item" required>
                                <option value="Autoads" <?= $current_ad_type === 'Autoads' ? 'selected' : '' ?>>Anúncios automáticos</option>
                                <option value="Manualads" <?= $current_ad_type === 'Manualads' ? 'selected' : '' ?>>Anúncios manuais</option>
                            </select>
                        </div>

                        <div class="ads-option">
                            <h5><i class="fas fa-robot me-2"></i>Anúncios Automáticos</h5>
                            <div class="ads-description">
                                Os anúncios são gerenciados automaticamente pelo sistema com posicionamento otimizado via api TMDB.
                            </div>
                        </div>

                        <div class="ads-option">
                            <h5><i class="fas fa-hand-pointer me-2"></i>Anúncios Manuais</h5>
                            <div class="ads-description">
                                Você tem controle total sobre o posicionamento e gerenciamento dos anúncios.
                            </div>
                        </div>

                        <div class="text-center mt-4">
                            <button type="submit" name="submit" class="btn btn-primary px-4">
                                <i class="fas fa-save me-2"></i>Salvar Configurações
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php 
$db->close();
include "includes/footer.php";
?>