<?php
ini_set('display_errors', 1);
if(session_status() === PHP_SESSION_NONE) session_start();
include(__DIR__ . '/functions.php');
$adTypeJsonPath = __DIR__ . '/ad_type.json';
$adb = new SQLite3('./api/.adb.db');
$adb3 = new SQLite3('./api/.db_logo.db');
$adb4 = new SQLite3('./api/.db_bg.db'); 
$adTypeData = json_decode(file_get_contents($adTypeJsonPath), true);
$currentAdType = $adTypeData['adType'] ?? 'manual';

if ($currentAdType === 'tmdb') {
    $adsPageUrl = "tmdb_api.php";
} else {
    $adsPageUrl = "ads.php";
}

if (!isset($_SESSION['name'])) {
    header("Location: index.php");
    exit;
}

$log_check = $db->select('users', '*', 'id = :id', '', [':id' => 1]);
$loggedinuser = !empty($log_check) ? $log_check[0]['username'] : null;

if ($_SESSION['name'] !== $loggedinuser) {
    header("Location: index.php");
    exit;
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>UNITV ONLY FLIX</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="author" content="ONLY FLIX">

    <!-- CSS: Apenas uma versão do Bootstrap e bibliotecas -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="css/themes/darkly/bootstrap.css" title="main">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <link href="css/simple-sidebar.css" rel="stylesheet">
<style>
/* Variáveis CSS para o tema MD3 Azul Neon */
:root {
    --md3-primary: #00b8ff; /* Azul Neon Principal */
    --md3-primary-gradient: linear-gradient(45deg, #00d0ff, #0088ff); /* Gradiente para botões e hover */
    --md3-secondary: #00ffe0; /* Azul Ciano Neon para acentos */
    --md3-background: #0b101a; /* Fundo escuro */
    --md3-surface: #121a2a; /* Superfícies um pouco mais claras (navbar) */
    --md3-surface-container: #1c2640; /* Superfícies de contêiner (sidebar, cards) */
    --md3-on-surface: #d0f8ff; /* Texto e ícones na superfície */
    --md3-outline: #2a4869; /* Borda e divisores */
    --md3-shadow: rgba(0, 184, 255, 0.35); /* Sombra com tom neon */
}

/* Estilos globais para corpo */
body {
    background-color: var(--md3-background);
    color: var(--md3-on-surface);
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    margin: 0;
    padding: 0;
    transition: background-color 0.5s cubic-bezier(0.4, 0, 0.2, 1),
                color 0.5s cubic-bezier(0.4, 0, 0.2, 1);
}

/* Wrapper principal do layout */
#wrapper {
    display: flex;
    min-height: 100vh;
    overflow-x: hidden;
    flex-direction: row; /* Garante que a sidebar e o conteúdo fiquem lado a lado */
}

/* Estilos da Sidebar */
#sidebar-wrapper {
    background: var(--md3-surface-container);
    width: 250px;
    min-height: 100vh;
    box-shadow: 5px 0 20px var(--md3-shadow);
    display: flex;
    flex-direction: column;
    justify-content: center; /* Centraliza verticalmente o conteúdo da sidebar */
    padding-top: 1rem;
    transition: background-color 0.5s ease;
}

.sidebar-heading {
    text-align: center;
    padding: 1rem;
    font-size: 1.5rem;
    font-weight: 700;
    color: var(--md3-primary);
    border-bottom: 1px solid var(--md3-outline);
    margin-bottom: 1.2rem;
    text-shadow:
        0 0 6px #00b8ff,
        0 0 12px #00e0ff,
        0 0 18px #00e0ff,
        0 0 24px #0088ff;
    transition: color 0.3s ease;
}

.list-group {
    display: flex;
    flex-direction: column;
    gap: 0.8rem; /* Espaçamento entre os itens da lista */
    padding: 0 1rem;
}

.list-group-item {
    background: transparent;
    border: none;
    color: rgba(208, 248, 255, 0.95); /* Cor do texto dos itens da lista */
    padding: 15px 18px;
    border-radius: 16px;
    transition:
        background-color 0.35s cubic-bezier(0.4, 0, 0.2, 1),
        transform 0.35s cubic-bezier(0.4, 0, 0.2, 1),
        box-shadow 0.35s ease;
    display: flex;
    align-items: center;
    gap: 1rem;
    font-weight: 600;
    white-space: nowrap; /* Evita quebra de linha em itens longos */
    cursor: pointer;
    position: relative; /* Necessário para o efeito ripple */
    overflow: hidden; /* Corta o efeito ripple fora do item */
    user-select: none; /* Impede a seleção de texto nos itens */
}

.list-group-item:hover {
    background: var(--md3-primary-gradient);
    color: #fff; /* Cor do texto no hover */
    transform: translateX(8px); /* Deslocamento no hover */
    box-shadow:
        0 0 12px #00b8ff,
        0 0 24px #00d0ff,
        0 0 36px #0088ff;
}

.list-group-item i {
    min-width: 26px;
    text-align: center;
    font-size: 1.2rem;
    transition: transform 0.4s ease, color 0.4s ease, text-shadow 0.4s ease;
    color: rgba(208, 248, 255, 0.8); /* Cor dos ícones */
    filter: drop-shadow(0 0 2px #00b8ff); /* Sombra neon suave nos ícones */
}

.list-group-item:hover i {
    transform: scale(1.4) rotate(5deg); /* Animação do ícone no hover */
    color: var(--md3-secondary); /* Cor secundária neon no hover */
    text-shadow:
        0 0 10px #00ffe0,
        0 0 20px #00ffe0;
}

.list-group-item:active {
    transform: scale(0.95);
    opacity: 0.85;
}

.list-group-item.active i {
    color: var(--md3-secondary); /* Cor secundária neon para item ativo */
    text-shadow:
        0 0 20px #00ffe0,
        0 0 40px #00ffe0,
        0 0 60px #00ffe0;
}

.sidebar-footer {
    text-align: center;
    color: rgba(208, 248, 255, 0.6);
    font-size: 0.9rem;
    padding: 1rem;
    border-top: 1px solid var(--md3-outline);
    margin-top: auto; /* Empurra o rodapé para baixo */
    user-select: none;
}

/* Estilos do conteúdo da página */
#page-content-wrapper {
    flex: 1; /* Ocupa o restante do espaço disponível */
    background-color: var(--md3-background);
    padding: 2rem;
    transition: background-color 0.5s ease;
}

/* Estilos da Navbar */
.navbar {
    background-color: var(--md3-surface);
    box-shadow:
        0 3px 14px var(--md3-shadow),
        inset 0 -1px 2px rgba(0, 0, 0, 0.3);
    padding: 0.75rem 1rem;
    display: flex;
    align-items: center;
    justify-content: space-between;
    flex-wrap: wrap;
    color: var(--md3-on-surface);
    user-select: none;
}

.navbar-dark .navbar-brand,
.navbar-dark .btn {
    color: var(--md3-on-surface);
    text-shadow:
        0 0 6px #00b8ff,
        0 0 12px #00d0ff;
}

/* Estilos dos botões */
.btn {
    background: var(--md3-primary-gradient);
    color: white;
    border: none;
    border-radius: 26px;
    padding: 0.6rem 1.5rem;
    transition:
        background 0.5s cubic-bezier(0.4, 0, 0.2, 1),
        transform 0.25s ease,
        box-shadow 0.5s ease;
    position: relative;
    overflow: hidden; /* Necessário para o efeito ripple */
    box-shadow:
        0 0 8px #00b8ff,
        0 0 20px #00d0ff;
    font-weight: 700;
    user-select: none;
}

.btn:hover {
    background: linear-gradient(45deg, #00e6ff, #0099ff);
    box-shadow:
        0 0 20px #00e6ff,
        0 0 40px #0099ff,
        0 0 60px #00e6ff;
}

.btn:active {
    transform: scale(0.96);
}

/* Estilos dos Modals */
.modal-content {
    background-color: var(--md3-surface);
    color: var(--md3-on-surface);
    border-radius: 18px;
    box-shadow:
        0 12px 36px rgba(0, 184, 255, 0.55),
        inset 0 0 20px rgba(0, 255, 255, 0.15); /* Sombra interna para um toque neon */
    transition: background-color 0.5s ease;
}

/* Estilos dos Dropdowns */
.dropdown-item {
    color: rgba(208, 248, 255, 0.95);
    padding: 16px 24px;
    transition:
        background-color 0.4s cubic-bezier(0.4, 0, 0.2, 1),
        color 0.4s ease;
    font-weight: 600;
    user-select: none;
}

.dropdown-item:hover {
    background: var(--md3-primary-gradient);
    color: #fff;
    text-shadow:
        0 0 14px #00d0ff,
        0 0 24px #00b8ff;
}

/* Estilos dos Cards */
.card {
    background-color: var(--md3-surface-container);
    color: var(--md3-on-surface);
    border-radius: 18px;
    box-shadow:
        0 6px 22px var(--md3-shadow);
    transition: box-shadow 0.4s ease;
    font-weight: 600;
    user-select: none;
}

.card:hover {
    box-shadow:
        0 12px 36px rgba(0, 184, 255, 0.55),
        0 0 40px rgba(0, 255, 255, 0.3); /* Sombra neon mais intensa no hover */
}

/* Efeito Ripple (Onda ao Clicar) */
.ripple {
    position: relative;
    overflow: hidden;
}

.ripple-effect {
    position: absolute;
    border-radius: 50%;
    background: rgba(0, 184, 255, 0.35); /* Cor do efeito ripple */
    transform: scale(0);
    animation: ripple-md3 700ms cubic-bezier(0.4, 0, 0.2, 1);
    pointer-events: none; /* Garante que o ripple não bloqueie eventos do mouse */
    filter:
        drop-shadow(0 0 5px #00b8ff)
        drop-shadow(0 0 12px #00d0ff);
}

@keyframes ripple-md3 {
    to {
        transform: scale(3);
        opacity: 0;
    }
}

/* Media Queries para Responsividade */
@media (min-width: 768px) {
    #sidebar-wrapper {
        margin-left: 0;
    }

    #page-content-wrapper {
        min-width: 0;
        width: 100%;
    }
}
</style>
</head>
<body>
<div class="d-flex" id="wrapper">
    <div id="sidebar-wrapper">
        <div class="sidebar-heading">UNITV ONLY FLIX</div>
        <div class="list-group list-group-flush">
             <a class="list-group-item list-group-item-action" href="dns.php">
                <i class="fa fa-cogs"></i>&nbsp;&nbsp;Ajustes de DNS
            </a>
            <a class="list-group-item list-group-item-action" href="playlists.php">
                <i class="fa fa-user"></i>&nbsp;&nbsp;Usuários conectado
            </a>
             <a class="list-group-item list-group-item-action" href="ads3.php">
                <i class="fa fa-futbol"></i>&nbsp;&nbsp;Enviar Anúncio 01
            </a>
            <a class="list-group-item list-group-item-action" href="ads2.php">
                <i class="fa fa-futbol"></i>&nbsp;&nbsp;Enviar Anúncio 02
            </a>
            <a class="list-group-item list-group-item-action" href="ads4.php">
                <i class="fa fa-futbol"></i>&nbsp;&nbsp;Enviar Anúncio 03
            </a>
            <a class="list-group-item list-group-item-action" href="mRTXAdsSetting.php">
                <i class="fa fa-image"></i>&nbsp;&nbsp;Autoads/Manual
            
             </a>
            <a class="list-group-item list-group-item-action" href="logo.php">
                <i class="fa fa-image"></i>&nbsp;&nbsp;Imagem UNITV
                
             </a>
            <a class="list-group-item list-group-item-action" href="bg.php">
                <i class="fa fa-image"></i>&nbsp;&nbsp;Fundo UNITV

            </a> 
            <a class="list-group-item list-group-item-action" href="qrcode.php">
                <i class="fa fa-image"></i>&nbsp;&nbsp;USER QR Code
            </a>
           <a class="list-group-item list-group-item-action" href="base64.php">
            <i class="fa fa-cogs"></i>&nbsp;&nbsp;API Config
            </a>
            <a class="list-group-item list-group-item-action" href="pagamento.php">
                <i class="fa fa-image"></i>&nbsp;&nbsp;Pagamento
            </a>
            <a class="list-group-item list-group-item-action" href="user.php">
                <i class="fa fa-lock"></i>&nbsp;&nbsp;Update Credentials
            </a>
        </div>
       <div class="sidebar-footer">
            <a href="https://t.me/brappsoficial" target="_blank" style="color: rgba(255, 255, 255, 0.6);">
                © <?=date("Y")?> UNITV ONLY FLIX
          </a>
        </div>
    </div>
 <div id="page-content-wrapper">
        <nav class="navbar navbar-expand-lg navbar-dark">
            <button class="btn btn-primary" id="menu-toggle" aria-label="Toggle menu">
                <img src="img/logo.png" width="25" height="25" class="d-inline-block align-top" alt="IBO XFAST">
            </button>
            <div class="center" id="pageMessages"></div>
            <a href="logout.php" class="btn btn-danger ml-auto animate__animated animate__pulse">Logout</a>
        </nav>
        <div class="container-fluid"><br>

  <!-- JS: Ao final para melhor desempenho -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js" defer></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js" defer></script>
<script>
  // Efeito ripple otimizado com requestAnimationFrame para suavidade e desempenho
  document.addEventListener('DOMContentLoaded', () => {
    document.querySelectorAll('.ripple').forEach(btn => {
      btn.addEventListener('click', function(e) {
        const circle = document.createElement('span');
        circle.classList.add('ripple-effect');
        const rect = this.getBoundingClientRect();
        const size = Math.max(rect.width, rect.height);
        circle.style.width = circle.style.height = size + 'px';
        circle.style.left = (e.clientX - rect.left - size / 2) + 'px';
        circle.style.top = (e.clientY - rect.top - size / 2) + 'px';

        this.appendChild(circle);

        // Usar requestAnimationFrame para remoção suave após animação
        let start;
        function animate(timestamp) {
          if (!start) start = timestamp;
          const elapsed = timestamp - start;
          if (elapsed > 700) {
            circle.remove();
            return;
          }
          requestAnimationFrame(animate);
        }
        requestAnimationFrame(animate);
      });
    });
  });
</script>
</body>
</html>
